# number of timesteps to iterate the model
t_max = 300

# initial population sizes of hosts and parasitoids
N0 = 80
P0 = 20

# parameter values
r = 0.05

b = 0.0008
c = 10.0

# initialise empty vectors to store the population sizes
# over time
Ns = numeric(t_max+1)
Ps = numeric(t_max+1)

# set population sizes in the first timestep to N0 and P0
Ns[1] = N0
Ps[1] = P0

# execute a loop from time t=1 to t=t_max-1, in each step
# calculating the values of the population sizes at time t+1
for ( t in 1:t_max )
  {
  Ns[t+1] = (1+r)*Ns[t]*exp(-b*Ps[t])
  Ps[t+1] = c*Ns[t]*(1-exp(-b*Ps[t]))
  }

# plot the results
plot(0:t_max,Ns,pch=19,type='o',col='blue',
     xlab='Time (t)',ylab='Population size',ylim=c(0,3000))
lines(0:t_max,Ps,pch=19,type='o',col='red') 
